`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer: 
// 
// Create Date: 11/13/2023 08:31:42 PM
// Design Name: 
// Module Name: enchanted_counter
// Project Name: 
// Target Devices: 
// Tool Versions: 
// Description: 
// 
// Dependencies: 
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
//////////////////////////////////////////////////////////////////////////////////

module enchanted_counter(
        clk,
        rst_n,
        oe,
        we,
        incr,
        in,
        out,
        disp_out
    );

    parameter width = 16;

    input               clk;
    input               rst_n;
    input               oe;         //
    input               we;         //
    input               incr;       //incremental command
    input [width-1 : 0] in;         //
    output[width-1 : 0] out;        //
    output[width-1 : 0] disp_out;   //debug wire, for FPGA implementation

    reg [width-1 : 0]   data;

    always @(posedge clk) begin
        if(!rst_n)
            data <= 0;
        else if(we) //write enable has priority over incr
            data <= in;        
        else if(incr)
            data <= data+1;
     
    end

    assign out = oe ? data : 0;
    assign disp_out = data;
endmodule
